## Playbook: Exfiltration over USB

### MITRE

| Tactic | Technique ID | Technique Name | Sub-Technique Name | Platforms | Permissions Required |
| ------ | ------------ | -------------- | ------------------ |---------- |--------------------- |
| Exfiltration | T1052.001 | Exfiltration Over Physical Medium | Exfiltration over USB | Linux, Windows, macOS | Physical access |



```
(P) Preparation

1. If feasible, block the usage of USB-Mass-Storage-Devices.
2. Implement logging for USB-Devices, e.g. by added the corresponding rules to your sysmon config ([Event ID 6416](https://www.ultimatewindowssecurity.com/securitylog/encyclopedia/event.aspx?eventid=6416)).
 
```
  
Assign steps to individuals or teams to work concurrently, when possible; this playbook is not purely sequential. Use your best judgment.

**Assumption: You do not have access to the USB-Device which was used for the exfiltration**
--------------

### Investigate

1. **Scope of the attack**
    * gather IOCs on the USB-device (vendor / product-id) and see, if there are multiple assets affected.
    * analyze log files to get a better understanding, what data was accessed at the time and could have been transferred. The target is to get a better understanding of the goal of the attacker.
    * analyze if the user, which created the task, in order to identify possible other attacks
2. **Analyze USB-Exfiltration**
    * timestamps of connecting the USB-device
    * which data was accessed at the time and could have been exfiltrated
    * user under whom the USB-device got connected
3. **Determine Severity**
    * number of affected assets
    * data at risk
    * clear path of attack (e.g. physical access by third party or insider job)


--------------

### Remediate

* **Plan remediation events** where these steps are launched together (or in coordinated fashion), with appropriate teams ready to respond to any disruption.
* **Consider the timing and tradeoffs** of remediation actions: your response has consequences.

#### Contain

1. **Originating account**
   * Disable the user, under whom the action was taken. Also disable all correlated accounts and maybe other accounts which were used on the same machine, if the user has higher admin rights on the machine.
2. **Blocking of USB-mass-devices**
   * Consider disabling USB-mass-devices if feasible.

#### Eradicate

1. **Solve originating attack**
   * The exfiltration already happened and itself no longer posses a threat to the machine. The original vector, e.g. physical access by third party or insider job should be identified and be solved.

#### Reference: Remediation Resources

1. **Typically not needed**

--------------

### Communicate

In addition to the general steps and guidance in the incident response plan:
1. **Should be covered in default response plan**


--------------

### Recover

In addition to the general steps and guidance in the incident response plan:
1. **Typically leaves no traces except forensic evidence on the machine, therefore recovery not needed**

--------------
  
### Lessons Learned
  
1. Follow default lessons learned procedures

--------------

### Resources

#### Additional Information

1. [Mitre](https://attack.mitre.org/techniques/T1052/001/)

